const mongoose = require('mongoose');
const User = require('./models/User');

mongoose.connect('mongodb://localhost:27017/tad-system')
  .then(async () => {
    console.log('Connected to MongoDB');
    const users = await User.find({}, 'name email isVerified phone').limit(10);
    console.log('Existing users:');
    users.forEach(user => {
      console.log(`- Name: ${user.name}, Email: ${user.email}, Verified: ${user.isVerified}, Phone: ${user.phone || 'Not set'}`);
    });
    process.exit(0);
  })
  .catch(err => {
    console.error('Error:', err);
    process.exit(1);
  });