const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/authMiddleware');
const { isAdmin } = require('../middleware/adminMiddleware');
const {
    getAllDiscounts,
    getActiveDiscounts,
    createDiscount,
    updateDiscount,
    deleteDiscount
} = require('../controllers/discountController');

// Public route
router.get('/active', getActiveDiscounts);

// Admin routes
router.get('/', protect, isAdmin, getAllDiscounts);
router.post('/', protect, isAdmin, createDiscount);
router.put('/:discountId', protect, isAdmin, updateDiscount);
router.delete('/:discountId', protect, isAdmin, deleteDiscount);

module.exports = router;

