const express = require('express');
const router = express.Router();
const { 
    register, 
    login, 
    logoutUser,
    verifyOTP, 
    resendOTP, 
    verifyToken,
    refreshToken,
    updateDarkMode, 
    updateUserPhone 
} = require('../controllers/authController');
const { protect } = require('../middleware/authMiddleware');

router.post('/register', register);
router.post('/login', login);
router.post('/logout', logoutUser);
router.post('/verify-otp', verifyOTP);
router.post('/resend-otp', resendOTP);
router.get('/verify', verifyToken);
router.get('/refresh', refreshToken);
router.put('/darkmode', protect, updateDarkMode);
router.put('/phone', protect, updateUserPhone);

module.exports = router;
