const express = require('express');
const { protect } = require('../middleware/authMiddleware');
const {
    createAssignment,
    getCourseAssignments,
    getAssignment,
    submitAssignment,
    updateAssignment,
    deleteAssignment
} = require('../controllers/assignmentController');

const router = express.Router();

// All routes require authentication
router.use(protect);

router.post('/', createAssignment);
router.get('/course/:courseId', getCourseAssignments);
router.get('/:assignmentId', getAssignment);
router.post('/:assignmentId/submit', submitAssignment);
router.put('/:assignmentId', updateAssignment);
router.delete('/:assignmentId', deleteAssignment);

module.exports = router;

