const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');

const userSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true,
        unique: true
    },
    phone: {
        type: String,
        required: false
    },
    password: {
        type: String,
        required: true
    },
    darkMode: {
        type: Boolean,
        default: false
    },
    role: {
        type: String,
        enum: ['admin', 'solo', 'team', 'company'],
        default: 'solo'
    },
    status: {
        type: String,
        enum: ['active', 'inactive', 'suspended'],
        default: 'active'
    },
    lastLogin: {
        type: Date,
        default: Date.now
    },
    loginCount: {
        type: Number,
        default: 0
    },
    isVerified: { type: Boolean, default: false },
    otp: {
        code: { type: String },
        createdAt: { type: Date },
        expiresAt: { type: Date }
    },
    teamMembers: [{
        email: { type: String },
        role: { type: String, enum: ['admin', 'member'], default: 'member' }
    }],
    lastLogin: { type: Date },
    loginCount: { type: Number, default: 0 },
    status: { type: String, enum: ['active', 'inactive', 'suspended'], default: 'active' },
    // Premium subscription fields
    premiumActive: { type: Boolean, default: false },
    premiumExpiry: { type: Date },
    planType: { 
        type: String, 
        enum: ['free', 'premium-individual', 'team', 'small-company', 'medium-company', 'large-company'],
        default: 'free'
    },
    premiumHistory: [{
        planType: String,
        activatedAt: Date,
        expiredAt: Date,
        durationMonths: Number
    }],
    // AI usage tracking for free users
    aiUsage: {
        dailyQueries: { type: Number, default: 0 },
        lastResetDate: { type: Date, default: Date.now }
    },
    // Free trial fields
    trialStartDate: { type: Date },
    trialEndDate: { type: Date },
    trialUsed: { type: Boolean, default: false }
}, { timestamps: true });

module.exports = mongoose.model('User', userSchema);
