const mongoose = require('mongoose');

const groupTaskSchema = new mongoose.Schema({
    group: { type: mongoose.Schema.Types.ObjectId, ref: 'Group', required: true },
    sectionId: { type: mongoose.Schema.Types.ObjectId, ref: 'GroupSection', default: null }, // Optional: assign task to a section
    title: { type: String, required: true },
    description: { type: String },
    assignedTo: [{ type: String }], // emails
    createdBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },
    subtasks: [{ type: mongoose.Schema.Types.ObjectId, ref: 'GroupSubtask' }],
    priority: { type: String, enum: ['low', 'medium', 'high'], default: 'medium' },
    dueDate: { type: Date, default: null },
    status: { type: String, enum: ['pending', 'completed'], default: 'pending' },
    completed: { type: Boolean, default: false },
    points: { type: Number, default: 0 }
}, { timestamps: true });

module.exports = mongoose.model('GroupTask', groupTaskSchema);
