const mongoose = require('mongoose');

const groupSubtaskSchema = new mongoose.Schema({
    groupTask: { type: mongoose.Schema.Types.ObjectId, ref: 'GroupTask', required: true },
    title: { type: String, required: true },
    assignedTo: [{ type: String }], // emails
    status: { type: String, enum: ['pending', 'completed'], default: 'pending' }
}, { timestamps: true });

module.exports = mongoose.model('GroupSubtask', groupSubtaskSchema);
