const mongoose = require('mongoose');

const groupMembershipSchema = new mongoose.Schema({
    group: { type: mongoose.Schema.Types.ObjectId, ref: 'Group', required: true },
    user: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: false }, // can be null until user registers
    email: { type: String, required: true },
    role: { type: String, enum: ['member', 'creator'], default: 'member' },
    canViewAllTasks: { type: Boolean, default: false }
}, { timestamps: true });

module.exports = mongoose.model('GroupMembership', groupMembershipSchema);
