const mongoose = require('mongoose');

const discountSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true
    },
    type: {
        type: String,
        enum: ['monthly', 'yearly', 'custom'],
        required: true
    },
    discountType: {
        type: String,
        enum: ['percentage', 'flat'],
        required: true
    },
    value: {
        type: Number,
        required: true,
        min: 0
    },
    active: {
        type: Boolean,
        default: true
    },
    description: {
        type: String
    },
    applicablePlans: [{
        type: String,
        enum: ['premium-individual', 'team', 'small-company', 'medium-company', 'large-company']
    }],
    startDate: {
        type: Date,
        default: Date.now
    },
    endDate: {
        type: Date
    }
}, { timestamps: true });

module.exports = mongoose.model('Discount', discountSchema);

