const mongoose = require('mongoose');

const courseSubscriptionSchema = new mongoose.Schema({
    user: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    course: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Course',
        required: true
    },
    enrolledAt: {
        type: Date,
        default: Date.now
    },
    progress: {
        type: Number,
        default: 0
    },
    completedAssignments: [{
        assignment: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'Assignment'
        },
        completedAt: Date,
        score: Number
    }],
    status: {
        type: String,
        enum: ['active', 'completed', 'dropped'],
        default: 'active'
    }
}, { timestamps: true });

// Ensure one subscription per user per course
courseSubscriptionSchema.index({ user: 1, course: 1 }, { unique: true });

module.exports = mongoose.model('CourseSubscription', courseSubscriptionSchema);

