const Feedback = require('../models/Feedback');
const User = require('../models/User');
const emailService = require('../utils/emailService');

exports.submitFeedback = async (req, res) => {
    try {
        const { email, message } = req.body;
        if (!email || !message) {
            return res.status(400).json({ message: 'Email and message are required.' });
        }
        // Try to get the user's name from the User model
        let name = '';
        const user = await User.findOne({ email });
        if (user) name = user.name;
        const feedback = new Feedback({ email, name, message });
        await feedback.save();
        // Send to admin (anonymized)
        await emailService.sendMail({
            to: process.env.ADMIN_EMAIL || 'nadyahmd88@gmail.com',
            subject: 'New User Feedback',
            text: `Feedback received:\n${message}\n\nFrom: ${name ? name + ' <' + email + '>' : email}`
        });
        res.status(201).json({ message: 'Feedback submitted successfully.' });
    } catch (error) {
        res.status(500).json({ message: 'Failed to submit feedback', error: error.message });
    }
};

exports.getAllFeedbacks = async (req, res) => {
    try {
        const feedbacks = await Feedback.find().sort({ createdAt: -1 });
        res.status(200).json(feedbacks);
    } catch (error) {
        res.status(500).json({ message: 'Failed to fetch feedbacks', error: error.message });
    }
};

exports.deleteFeedback = async (req, res) => {
    try {
        const { id } = req.params;
        const deleted = await Feedback.findByIdAndDelete(id);
        if (!deleted) {
            return res.status(404).json({ message: 'Feedback not found' });
        }
        res.status(200).json({ message: 'Feedback deleted successfully.' });
    } catch (error) {
        res.status(500).json({ message: 'Failed to delete feedback', error: error.message });
    }
};
