const mongoose = require('mongoose');

const pricingPlanSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
        unique: true
    },
    planId: {
        type: String,
        required: true,
        unique: true,
        enum: ['free', 'premium-individual', 'team', 'small-company', 'medium-company', 'large-company']
    },
    description: {
        type: String,
        required: true
    },
    monthlyPrice: {
        type: Number,
        required: true,
        default: 0
    },
    yearlyPrice: {
        type: Number,
        required: true,
        default: 0
    },
    features: [{
        type: String
    }],
    maxWorkspaces: {
        type: Number,
        default: 1
    },
    maxTeamMembers: {
        type: Number,
        default: 0
    },
    maxEmployees: {
        type: Number,
        default: null // null means unlimited
    },
    pricePerEmployee: {
        type: Number,
        default: 0
    },
    active: {
        type: Boolean,
        default: true
    }
}, { timestamps: true });

module.exports = mongoose.model('PricingPlan', pricingPlanSchema);

