const mongoose = require('mongoose');

const GroupTaskSchema = new mongoose.Schema({
    name: { type: String, required: true },
    description: { type: String, default: '' },
    priority: { type: String, enum: ['low', 'medium', 'high'], default: 'medium' },
    isImportant: { type: Boolean, default: false },
    dueDate: { type: Date, default: null },
    tags: [{ type: String }],
    isDone: { type: Boolean, default: false },
    assignedTo: [{ type: String }], // emails
    createdBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
    points: { type: Number, default: 0 },
    lastNotified: { type: Date }
}, { timestamps: true });

const GroupSectionSchema = new mongoose.Schema({
    groupId: { 
        type: mongoose.Schema.Types.ObjectId, 
        ref: 'Group', 
        required: true,
        index: true
    },
    name: { 
        type: String, 
        required: true 
    },
    description: { 
        type: String, 
        default: '' 
    },
    tasks: [GroupTaskSchema],
    createdBy: { 
        type: mongoose.Schema.Types.ObjectId, 
        ref: 'User', 
        required: true 
    },
    isPublic: { 
        type: Boolean, 
        default: false 
    },
    shareToken: { 
        type: String, 
        unique: true, 
        sparse: true 
    },
    isPubliclyViewable: { 
        type: Boolean, 
        default: false 
    },
    sharedWith: [{
        email: { type: String },
        accessLevel: { type: String, enum: ['read', 'write'], default: 'read' }
    }]
}, { timestamps: true });

// Index for efficient queries
GroupSectionSchema.index({ groupId: 1, createdAt: -1 });

module.exports = mongoose.model('GroupSection', GroupSectionSchema);

