const mongoose = require('mongoose');

// Validate a specific param as a MongoDB ObjectId
function validateObjectIdParam(paramName) {
  return (req, res, next) => {
    const value = req.params[paramName];
    if (value && !mongoose.Types.ObjectId.isValid(value)) {
      return res.status(400).json({ error: `Invalid ${paramName}` });
    }
    next();
  };
}

// Validate a specific query string value as ObjectId (if present)
function validateObjectIdQuery(queryName) {
  return (req, res, next) => {
    const value = req.query[queryName];
    if (value && !mongoose.Types.ObjectId.isValid(value)) {
      return res.status(400).json({ error: `Invalid ${queryName}` });
    }
    next();
  };
}

// Validate a specific body field as ObjectId (if present)
function validateObjectIdBody(fieldName) {
  return (req, res, next) => {
    const value = req.body[fieldName];
    if (value && !mongoose.Types.ObjectId.isValid(value)) {
      return res.status(400).json({ error: `Invalid ${fieldName}` });
    }
    next();
  };
}

module.exports = {
  validateObjectIdParam,
  validateObjectIdQuery,
  validateObjectIdBody,
};